import { Linkedin, Mail, Phone, MapPin } from "lucide-react";
import { Link } from "wouter";
import logo from "@assets/Cadivity.png";

export function Footer() {
  return (
    <footer className="bg-slate-900 text-slate-200 pt-16 pb-8 border-t border-slate-800">
      <div className="container mx-auto px-4">
        <div className="grid grid-cols-1 md:grid-cols-4 gap-12 mb-12">
          
          {/* Brand Column */}
          <div className="space-y-8">
            <div className="flex items-center gap-2">
              <img src={logo} alt="Cadivity" className=" max-w-xs  h-auto bg-white rounded-lg " />
            </div>
            <p className="text-sm text-slate-400 max-w-xs leading-relaxed">
              Where CAD Automation boosts Productivity. Empowering engineering teams and individuals to work smarter — not harder.
            </p>
          </div>

          {/* Quick Links */}
          <div>
            <h3 className="font-display font-semibold text-white mb-6 text-lg">Services</h3>
            <ul className="space-y-3 text-sm text-slate-400">
              <li><Link href="/services" className="hover:text-accent transition-colors">CAD Automation</Link></li>
              <li><Link href="/services" className="hover:text-accent transition-colors">Plugin Development</Link></li>
              <li><Link href="/services" className="hover:text-accent transition-colors">Workflow Optimization</Link></li>
              <li><Link href="/services" className="hover:text-accent transition-colors">Data Processing</Link></li>
            </ul>
          </div>

          {/* Training */}
          <div>
            <h3 className="font-display font-semibold text-white mb-6 text-lg">Training</h3>
            <ul className="space-y-3 text-sm text-slate-400">
              <li><Link href="/courses" className="hover:text-accent transition-colors">Creo ProToolkit</Link></li>
              <li><Link href="/courses" className="hover:text-accent transition-colors">SolidWorks API</Link></li>
              <li><Link href="/courses" className="hover:text-accent transition-colors">Siemens NX Open</Link></li>
              <li><Link href="/courses" className="hover:text-accent transition-colors">CATIA CAA</Link></li>
            </ul>
          </div>

          {/* Contact */}
          <div>
            <h3 className="font-display font-semibold text-white mb-6 text-lg">Contact Us</h3>
            <ul className="space-y-4 text-sm text-slate-400">
              <li className="flex items-start gap-3">
                <Mail className="h-5 w-5 text-accent mt-0.5" />
                <a href="mailto:enquiry@cadivity.com" className="hover:text-white transition-colors">enquiry@cadivity.com</a>
              </li>
              <li className="flex items-start gap-3">
                <Phone className="h-5 w-5 text-accent mt-0.5" />
                <a href="tel:+916372495858" className="hover:text-white transition-colors">+91-6372495858</a>
              </li>
              {/* Added placeholder for address if needed, usually good for trust */}
              <li className="flex items-start gap-3">
                <MapPin className="h-5 w-5 text-accent mt-0.5" />
                <span>Available Worldwide</span>
              </li>
            </ul>
            <div className="flex gap-4 mt-6">
              <a href="#" className="bg-white/10 p-2 rounded-full hover:bg-accent hover:text-white transition-colors">
                <Linkedin className="h-4 w-4" />
              </a>
            </div>
          </div>
        </div>
        
        <div className="border-t border-slate-800 pt-8 flex flex-col md:flex-row justify-between items-center gap-4 text-xs text-slate-500">
          <p>&copy; {new Date().getFullYear()} Cadivity. All rights reserved.</p>
          <div className="flex gap-6">
            <a href="#" className="hover:text-white">Privacy Policy</a>
            <a href="#" className="hover:text-white">Terms of Service</a>
          </div>
        </div>
      </div>
    </footer>
  );
}
